@extends('user.user_master')
@section('user.user_content')
@if($result_name == "")
@section('user_title')
Download - Empty Files
@endsection
@else
@section('user_title')
Results - {{$result_name->course->course_name}}
@endsection

@endif
@php
$images = \App\Models\Theme::find(1);
@endphp
<section>
    <!-- Page Content -->
    <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
        <div class="container page-opacity">
            <div class="row">
                <div class="col-md-12">
                    <h1> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($result_name->course->course_name, 'ne') }} @else {{$result_name->course->course_name}} Results @endif</h1>
                    <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('The roots of education are bitter, but the fruit is sweet.', 'ne') }} @else The roots of education are bitter, but the fruit is sweet. @endif</span>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="section-department mt-5 mb-5 ">
    <div class="intro">
        <div class="bg-image h-100">
            <div class="mask d-flex align-items-center">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-12">
                            <div class="card">
                                <div class="card-body p-0">
                                    <div class="table-responsive" data-mdb-perfect-scrollbar="true" style="position: relative;">
                                        <table class="table table-striped mb-0">

                                            <thead>
                                                <tr>
                                                    <th colspan="5" class="bg-primary-color">
                                                        <p class="bg-primary-color p-2" style=" margin-bottom: -1px;">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Recent Notices', 'ne') }} @else Recent Notices @endif</p>
                                                    </th>
                                                </tr>
                                                <tr>
                                                    <th scope="col">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Published Date ', 'ne') }} @else Published Date  @endif</th>
                                                    <th scope="col">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Notice Title ', 'ne') }} @else Notice Title  @endif</th>
                                                    <th scope="col">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Files', 'ne') }} @else Files  @endif</th>
                                                    <th scope="col">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Published By ', 'ne') }} @else Published By @endif</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($result as $key=>$results)
                                                @php
                                                $result_file = \App\Models\DepartmentDownloadFile::where('download_id',$results->id)->get();
                                                @endphp
                                                <tr>
                                                    <td>@php
                                                        $year = $results->created_at->format('Y');
                                                        $month = $results->created_at->format('m');
                                                        $day = $results->created_at->format('d');
                                                        $date = Bsdate::eng_to_nep($year, $month, $day);
                                                        echo $date['nmonth'] . ' ' . $date['date'] .','. ' ' . $date['year'];
                                                        @endphp</td>
                                                    <td><a href="{{route('user.result_download_view',$results->id)}}"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($results->title, 'ne') }} @else {{$results->title}}  @endif</a></td>

                                                    <td>
                                                        @foreach($result_file as $file)   
                                                        <a href="{{route('user.result_download',$file->id)}}" ><i class="bi bi-file-earmark-pdf-fill" title="Download File"></i></a>
                                                        @endforeach
                                                    </td>
                                                    <td>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($results->user->name, 'ne') }} @else {{$results->user->name}}  @endif</td>

                                                </tr>
                                                @endforeach



                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection