@extends('user.user_master')
@section('user.user_content')
@php
$sliders = \App\Models\Slider::where('status', 1)->orderBy('id','DESC')->get();
$info = \App\Models\Information::latest()->get();
$course = \App\Models\CoursePage::orderBy('id','DESC')->get();
$user_message = \App\Models\Message::orderBy("id",'ASC')->get();
$about_message = \App\Models\About::find(1);
$theme = \App\Models\Theme::find(1);
$videos = \App\Models\IndexVideo::find(1);
$facilities = \App\Models\Reason::latest()->get();
$events = \App\Models\Event::latest()->paginate(10);
$news = \App\Models\NewsNotice::latest()->paginate(10);
$testimonials = \App\Models\Testimonial::latest()->get();
@endphp
@section('user_title')
Home - Madhyamik Bidhyalaya Tulsipur Center
@endsection
<!-------Hero Section Start------->
<section id="hero" class="hero">
    <div class="hero-container mb-lg-0">
        <div id="heroCarousel" class="carousel slide carousel-fade" data-ride="carousel">
            <ol class="carousel-indicators" id="hero-carousel-indicators"></ol>
            <div class="carousel-inner" role="listbox">
                <!-------Slide First------->
                @foreach ($sliders as $slider)
                <div class="carousel-item active">
                    <div class="carousel-background"><img class="lozad" src="{{ asset($slider->image) }}" alt="{{ $slider->slider_heading }}">
                    </div>
                    <div class="carousel-container">
                        <div class="carousel-content container">
                            <h2 data-aos="flip-right" data-aos="zoom-in" data-aos-easing="ease" data-aos-delay="400">
                                @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans( $slider->slider_heading, 'ne')  }} @else {{$slider->slider_heading}} @endif
                            </h2>
                            <p class="text-capitalize" data-aos="fade-up" data-aos-easing="ease" data-aos-delay="600">
                                @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($slider->slider_sub_heading, 'ne')  }} @else {{$slider->slider_sub_heading}} @endif

                            </p>
                            <div data-aos="fade-up" data-aos-easing="ease" data-aos-delay="800">
                                <a href="" class="btn-menu">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans( 'Our Courses', 'ne')  }} @else Our Courses @endif</a>
                                <a href="" class="btn-book"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans( 'Contact ', 'ne')  }} @else Contact Us @endif</a>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            <a class="carousel-control-prev" href="#heroCarousel" role="button" data-slide="prev">
                <span class="bi bi-arrow-left" aria-hidden="true"></span>
            </a>
            <a class="carousel-control-next" href="#heroCarousel" role="button" data-slide="next">
                <span class="bi bi-arrow-right" aria-hidden="true"></span>
            </a>
        </div>
    </div>
</section>
<!-------Hero Section End------->

<!-------Info Section start------->
<section class="info-section">
    <div class="container mt-5 mb-5">
        <div class="row">
            @foreach($info as $inf)
            <div class="col-xl-3 col-lg-3 p-3 col-md-6 col-sm-12 col-12">
                <div class="card p-3 text-center border shadow-lg">
                    <div class="card-grid-2-image">
                        <div class="image-box">
                            <figure><img src="{{asset($inf->logo)}}" alt="jobBox" style="height: 100px;" class="img-fluid"></figure>
                        </div>
                    </div>
                    <div class="card-block-info">
                        <h1>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($inf->count, 'ne')  }} @else {{$inf->count}} @endif</h1>
                        <p class="text-uppercase">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($inf->title, 'ne')  }} @else {{$inf->title}} @endif</p>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>

<!-------Info Section start------->
<section class="about-section bg-light pt-5 pb-5">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-md-6 right-info">
                <div class="row">
                    <div data-aos="fade-up" data-aos-anchor-placement="top-center">
                        <div class="heading-section pr-md-5">
                            <h2> <span class="fw-bold pb-5" id="typed1"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('About Us', 'ne')  }} @else About Us @endif</span></h2>
                            <p>@if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans(\Illuminate\Support\Str::limit($about_message->about, 670), 'ne') !!} @else {!! \Illuminate\Support\Str::limit($about_message->about, 650) !!} @endif</p>
                            <a href="{{route('user.about')}}" class="read-more text-white">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Read More', 'ne')  }} @else Read More @endif <i class="bi bi-arrow-right-circle-fill"></i></a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 user-info mt-lg-0 mt-4">
                <div id="carouselExampleSlidesOnly" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">
                        @foreach($user_message as $user)
                        <div class="carousel-item {{$user->user->id == 6 ?"active":""}}">
                            <div class="col-lg-12 col-md-12">
                                <div class="box-radius-8 border bg-white p-2 bg-9 hover-up">
                                    <div class="image">
                                        <figure><img class="mx-auto d-block" src="{{(!empty($user->user->profile_photo_path))?url($user->user->profile_photo_path):url('./uploads/default_images/no_image.jpg')}}" width="150px" class="img-fluid" alt="jobBox"></figure>
                                    </div>
                                    <div class="text-info text-center">
                                        <h3>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Mr.'. $user->user->name, 'ne')  }} @else Mr {{$user->user->name}} @endif </h3>
                                        <h6 class="">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($user->user->user_post, 'ne')  }} @else {{$user->user->user_post}} @endif</h6>
                                        <h6>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($user->user->phone, 'ne')  }} @else {{$user->user->phone}} @endif</h6>
                                        <div class="mt-15"><a class="read-more" href="{{url('/message-view',$user->id.'/'.$user->message_heading)}}">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Read Message ', 'ne')  }} @else Read Message @endif<i class="bi bi-arrow-right-circle-fill"></i></a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="notice-section mt-5 mb-5">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="row">
                    <div class="col-md-6 text-start col-6">
                        <h5 class="text-uppercase"> @if(session()->get('language') == 'nepali') {{\Stichoza\GoogleTranslate\GoogleTranslate::trans('News & Notice', 'ne')}} @else News & Notice @endif </h5>
                        <hr style="width: 60px; height: 3px; margin-top: -4px; color: #9e4c08;">
                    </div>
                    <div class="col-md-6 text-end view-all col-6">
                        <a href="{{route('user.notice')}}" class="text-danger"><u>@if(session()->get('language') == 'nepali') {{\Stichoza\GoogleTranslate\GoogleTranslate::trans('View All', 'ne')}} @else View All @endif</u></a>
                    </div>
                    @foreach($news as $new)
                    <a href="{{url('/news-notice-details',$new->id.'/'.$new->notice_title)}}" class="notice">
                            <p class="notice-title" style="color: #585858;">@if(session()->get('language') == 'nepali') {{\Stichoza\GoogleTranslate\GoogleTranslate::trans($new->notice_title, 'ne')}} @else {{$new->notice_title}} @endif </p>
                        </a>
                    <div class="col-md-6 notice text-start">
                       
                        <p class="badge bg-primary">@php
                            $year = $new->created_at->format('Y');
                            $month = $new->created_at->format('m');
                            $day = $new->created_at->format('d');
                            $date = Bsdate::eng_to_nep($year, $month, $day);
                            echo $date['nmonth'] . ' ' . $date['date'] .','. ' ' . $date['year']
                            @endphp</p>
                    </div>
                    <div class="col-md-6 text-end">
                        <p class="badge bg-danger">@if(session()->get('language') == 'nepali') {{\Stichoza\GoogleTranslate\GoogleTranslate::trans($new->notice_type, 'ne')}} @else {{$new->notice_type}} @endif</p>
                    </div>
                    <hr>
                    @endforeach

                </div>
            </div>
            <div class="col-md-1 align-middle justify-content-center">
                <p class="m-auto" style="border-right: 1px solid red;  height: 100%;"></p>
            </div>
            <div class="col-md-5">
                <div class="row">
                    <div class="col-md-6 text-start col-6">
                        <h5 class="text-uppercase">@if(session()->get('language') == 'nepali') {{\Stichoza\GoogleTranslate\GoogleTranslate::trans('Events', 'ne')}} @else Events @endif </h5>
                        <hr style="width: 60px; height: 3px; margin-top: -4px; color: #9e4c08;">
                    </div>

                    <div class="col-md-6 text-end view-all col-6">
                    <a href="{{route('user.user_event')}}" class="text-danger"><u>@if(session()->get('language') == 'nepali') {{\Stichoza\GoogleTranslate\GoogleTranslate::trans('View All', 'ne')}} @else View All @endif</u></a>
                    </div>
                    @foreach($events as $event)
                    <a href="{{url('/events-details',$event->id.'/'.$event->event_title)}}" class="notice"> <p class="notice-title"  style="color: #585858;">@if(session()->get('language') == 'nepali') {{\Stichoza\GoogleTranslate\GoogleTranslate::trans($event->event_title, 'ne')}} @else {{$event->event_title}}  @endif</p></a>
                    <div class="col-md-6 text-start">
                      
                        <p class="badge bg-primary">@php
                            $year = $event->created_at->format('Y');
                            $month = $event->created_at->format('m');
                            $day = $event->created_at->format('d');
                            $date = Bsdate::eng_to_nep($year, $month, $day);
                            echo $date['nmonth'] . ' ' . $date['date'] .','. ' ' . $date['year']
                            @endphp

                        </p>
                    </div>
                    <div class="col-md-6 text-end">
                        <p class="badge bg-danger">{{$event->event_time}}</p>
                    </div>
                    <hr>
                    @endforeach

                </div>
            </div>
        </div>
    </div>
</section>


<section class="bg-light program-offer">
    <div class="container course pb-5 pt-5 heading">
        <h2 class="h1-responsive font-weight-bold text-center my-1 text-capitalize">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Programs Offered', 'ne')  }} @else Programs Offered @endif</h2>
        <!--Section description-->
        <p class="text-center w-responsive mx-auto mb-4"> @if(session()->get('language') == 'nepali') {{\Stichoza\GoogleTranslate\GoogleTranslate::trans('Education is the kindling of a flame, not the filling of a vessel.', 'ne')}} @else Education is the kindling of a flame, not the filling of a vessel.  @endif</p>
        <div class="row courses pb-4">
            @foreach($course as $courses)
            <div class="col-md-4 col-12 pt-3">
                <div class="card p-2 box">
                    <div class="bg-image hover-overlay ripple" data-mdb-ripple-color="light">
                        <img src="{{$courses->image}}" class="img-fluid" />
                        <a href="#!">
                            <div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
                        </a>
                    </div>
                    <div class="card-body course-info">
                        <h4 class="card-title text-capitalize"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($courses->course->course_name, 'ne')  }} @else {{$courses->course->course_name}} @endif </h4>
                        <p class="card-text">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans(\Illuminate\Support\Str::limit($courses->short_description, 100), 'ne')  }} @else {{$courses->short_description}} @endif </p>
                        <a class="read-more" href="{{url('course-details-view',$courses->id.'/'.$courses->short_description_slug)}}">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Read More', 'ne')  }} @else Read More @endif <i class="bi bi-arrow-right-circle-fill"></i></a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>


<section class="">
    <!-- Video -->
    <div id="preview" class="basic-1" style="background: url('{{$theme->image}}') center center no-repeat;">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="p-heading p-large">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Watch Intro Video', 'ne')  }} @else Watch Intro Video @endif</div>
                </div> <!-- end of col -->
            </div> <!-- end of row -->
            <div class="row">
                <div class="col-lg-12">
                    <!-- Video Preview -->
                    <div class="image-container">
                        <div class="video-wrapper">
                            <a class="popup-youtube" href="{{$videos->link}}" class="fancybox" data-fancybox="image1">
                                <span class="video-play-button">
                                    <span></span>
                                </span>
                            </a>
                        </div> <!-- end of video-wrapper -->
                    </div> <!-- end of image-container -->
                    <!-- end of video preview -->
                </div> <!-- end of col -->
            </div> <!-- end of row -->
        </div> <!-- end of container -->
    </div> <!-- end of basic-1 -->
    <!-- end of video -->
</section>

<section class="why-choose pt-5 bg-light pb-5">
    <div class="container heading">
        <div class="row pb-5">
            <div class="col-md-12">
                <h2 class="h1-responsive font-weight-bold text-center my-1 text-capitalize">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Reasons to Choose Ma.Vi.
                    ', 'ne') }} @else Reasons to Choose Ma.Vi.
                    Center @endif</h2>
                <!--Section description-->
                <p class="text-center w-responsive mx-auto mb-4">@if(session()->get('language') == 'nepali') {{\Stichoza\GoogleTranslate\GoogleTranslate::trans('The past has no power over the present moment.', 'ne')}} @else The past has no power over the present moment.  @endif</p>
            </div>
            @foreach($facilities as $facilitie)
            <div class="col-lg-4 col-md-6 col-sm-6 col-12 mb-3">
                <div class="card-offer hover-up border p-3">
                    <div class="card-image"><img class="img-fluid" width="100px" src="{{asset($facilitie->icon)}}" alt="iori"></div>
                    <div class="card-info">
                        <h4 class="color-brand-1 mb-15"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($facilitie->reason_name, 'ne') }} @else {{$facilitie->reason_name}} @endif</h4>
                        <p>
                            @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans(\Illuminate\Support\Str::limit($facilitie->short_des, 150), 'ne') !!} @else {!! \Illuminate\Support\Str::limit($facilitie->short_des, 150) !!} @endif
                        </p>
                        <a class="read-more" href="{{url('facilitates-details',$facilitie->id.'/'.$facilitie->reason_name_slug)}}">Read
                            More <i class="bi bi-arrow-right-circle-fill"></i></a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
<section class="testimonials">
    <div class="container course pb-5 pt-5 heading">
        <div class="row">
            <div class="col-md-12">
                <h2 class="h1-responsive font-weight-bold text-center my-1 text-capitalize">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Testimonials', 'ne') }} @else Testimonials @endif</h2>
                <!--Section description-->
                <p class="text-center w-responsive mx-auto mb-4">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('You can never be overdressed or overeducated.', 'ne') }} @else You can never be overdressed or overeducated. @endif</p>
            </div>
            <div class="container">
                <div class="owl-testimonials owl-carousel">
                    @foreach($testimonials as $testimonial)
                    <div class="testimonial-item border m-1">
                        <div class="inner-content">
                            <img class="mb-3" src="{{(!empty($testimonial->image))?url($testimonial->image):url('./uploads/default_images/no_image.jpg')}}" alt="">
                            <h4>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($testimonial->user_name, 'ne') }} @else {{$testimonial->user_name}} @endif</h4>
                            <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($testimonial->user_type, 'ne') }} @else {{$testimonial->user_type}} @endif</span>
                            <p class="mt-1">"@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($testimonial->message, 'ne') }} @else {{$testimonial->message}} @endif "</p>
                        </div>
                    </div>
                    @endforeach

                </div>
            </div>
        </div>
    </div>
    </div>
</section>
@endsection