@extends('user.user_master')
@section('user.user_content')
@php
$images = \App\Models\Theme::find(1);
$course = \App\Models\CoursePage::orderBy('id','DESC')->get();
@endphp
@section('user_title')
Course - Programs Offered
@endsection
<section>
        <!-- Page Content -->
        <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
            <div class="container page-opacity">
                <div class="row">
                    <div class="col-md-12">
                        <h1> @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans('Programs Offered', 'ne') !!} @else Programs Offered @endif</h1>
                        <span>@if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans('An investment in knowledge pays the best interest.', 'ne') !!} @else An investment in knowledge pays the best interest. @endif</span>
                    </div>
                </div>
            </div>
        </div>
    </section>
      <!-------Info Section start------->
      <section class="bg-light program-offer">
        <div class="container course pb-5 pt-5 heading">
            <h2 class="h1-responsive font-weight-bold text-start my-1 mb-4 text-capitalize">
            @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans('Browse Courses', 'ne') !!} @else Browse Courses @endif</h2>
            <!--Section description-->
           
            <div class="row courses">
            @foreach($courses as $course)
                <div class="col-md-4 mt-3">
                    <div class="card p-2 box">
                        <div class="bg-image hover-overlay ripple" data-mdb-ripple-color="light">
                            <img src="{{$course->image}}"
                                class="img-fluid" />
                            <a href="#!">
                                <div class="mask" style="background-color: rgba(251, 251, 251, 0.15);"></div>
                            </a>
                        </div>
                        <div class="card-body course-info">
                            <h4 class="card-title text-capitalize"> @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans($course->course->course_name, 'ne') !!} @else {{$course->course->course_name}}  @endif</h4>
                            <p class="card-text">@if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans($course->short_description, 'ne') !!} @else {{$course->short_description}}  @endif</p>
                            <a class="read-more" href="{{url('course-details-view',$course->id.'/'.$course->short_description_slug)}}"> @if(session()->get('language') == 'nepali') {!! \Stichoza\GoogleTranslate\GoogleTranslate::trans('Read More', 'ne') !!} @else Read More  @endif <i class="bi bi-arrow-right-circle-fill"></i></a>
                        </div>
                    </div>
                </div>
                @endforeach

            </div>
        </div>
    </section>
    @endsection