    @php
    $message_name = \App\Models\Message::orderBy('id','ASC')->get();
    $course_name = \App\Models\Course::orderBy('id','ASC')->get();
    $theme = \App\Models\Theme::find(1);
    $admissions = \App\Models\Admission::latest()->get();
    @endphp
    <style>
        .dropdown:hover .dropdown-menu {
            display: block;
        }
    </style>
    <!-------Header Start------->
    <header id="header" data-aos="fade-up" data-aos-easing="ease" data-aos-delay="400">
        <!-------Top Bar Start------->
        <section id="topbar" class="topbar-socials mb-2 mb-lg-0 mb-sm-0  align-items-center pt-2 pb-2 bg-primary-color text-white topbar-transparent">
            <div class="container">
                <div class="row left-info">
                    <div class="col-lg-8 text-start left-info d-none d-lg-flex">
                        <span class="email-info me-3" style="margin-top: 5px;"><i class="bi bi-geo-alt-fill mx-1"></i>
                            @if(session()->get('language') == 'nepali') तुलसीपुर उपमहानगरपालिका @else Tulsipur Sub-Metropolitan City @endif </span>
                        <span class="me-3" style="margin-top: 5px;"><i class="bi bi-telephone-fill mx-1"></i> <a class="text-white" href="tel: {{$theme->phone}} ">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($theme->phone, 'ne')  }}</a> / <a class="text-white" href="tel: {{$theme->telephone}} ">{{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($theme->telephone, 'ne')  }}</a> @else {{$theme->phone}} / {{ $theme->telephone}} @endif</span>
                        <span> <a href="{{route('user.application')}}" class="me-3"><button class="btn btn-light btn-blinking btn-sm text-primary-color"><i class="bi bi-telephone-fill me-1"> </i> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Entrance Application', 'ne')  }} @else Entrance Application @endif</button></a></span>
                    </div>
                    <div class="col-lg-4 text-center right-info col-sm-6 text-lg-end">
                        <a href="{{route('user.contact')}}" class="me-3"><button class="btn btn-light btn-sm text-primary-color"><i class="bi bi-telephone-fill me-1"> </i> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Contact', 'ne')  }} @else Contact Us @endif</button></a>
                        <a href="{{route('user.notice')}}" class="text-white me-3"><i class="bi bi-printer"></i></a>
                        <a href="{{route('user.download')}}" class="text-white me-3"><i class="bi bi-download"></i></a>
                        @if(session()->get('language') == 'nepali')
                        <a href="{{route('english.language')}}" class="me-3 btn btn-light btn-sm" style="border-radius: 50px; color: #075e89; padding-left:20px!important; padding-right:20px!important;">English</a></li>
                        @else
                        <a href="{{route('nepali.language')}}" class="btn btn-light btn-sm me-3 pe-1 ps-1" style="border-radius: 50px; color: #075e89; padding-left:20px!important; padding-right:20px!important;font-weight:600">Nepali</a></li>
                        @endif


                    </div>
                </div>
            </div>
        </section>
    </header>
    <!-------Top Bar End------->

    <nav class="navbar navbar-expand-lg navbar-light bg-light shadow" data-aos="zoom-in" data-aos-easing="linear" data-aos-duration="1500">
        <div class="container">
            <a class="navbar-brand" href="{{url('/')}}"> @if(session()->get('language') == 'nepali') <img src="{{ asset($theme->logo_np)}}" alt="" height="50px"> @else <img src="{{ asset($theme->logo)}}" alt="" height="50px"> @endif</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="bi bi-list"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav ms-auto mb-lg-0">
                    <li class="nav-item dropdown secondDropDown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('About Us', 'ne')  }} @else About Us @endif
                        </a>
                        <ul class="dropdown-menu dropdown-menu-show-2" aria-labelledby="navbarDropdown">
                            <li><a class="dropdown-item" href="{{route('user.about')}}">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Ma.Vi. Center', 'ne')  }} @else Ma.Vi. Center @endif</a></li>
                            @foreach($message_name as $name)
                            <li><a class="dropdown-item" href="{{url('/message-view',$name->id.'/'.$name->message_heading)}}"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($name->message_heading, 'ne')  }} @else {{$name->message_heading}} @endif</a></li>
                            @endforeach
                            <li><a class="dropdown-item" href="{{route('user.staff')}}">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Faculity Staff ', 'ne')  }} @else Faculity Staff @endif</a></li>
                            <li><a class="dropdown-item" href="{{route('user.academics')}}"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Academics', 'ne')  }} @else Academics @endif</a></li>
                        </ul>
                    </li>
                    <li class="nav-item dropdown secondDropDown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Departments', 'ne')  }} @else Departments @endif
                        </a>
                        <ul class="dropdown-menu dropdown-menu-show-2" aria-labelledby="navbarDropdown">
                            @foreach($course_name as $course)
                            <li><a class="dropdown-item" href="{{url('department',$course->id.'/'.$course->course_name_slug)}}"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($course->course_name, 'ne')  }} @else {{$course->course_name}} @endif</a></li>
                            @endforeach
                        </ul>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="{{route('user.course')}}">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Courses', 'ne')  }} @else Courses @endif</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{route('user.facilitates')}}"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Facilites', 'ne')  }} @else Facilites @endif</a>
                    </li>
                    <li class="nav-item dropdown secondDropDown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Gallery', 'ne')  }} @else Gallery @endif
                        </a>
                        <ul class="dropdown-menu dropdown-menu-show-2" aria-labelledby="navbarDropdown">
                            <li><a class="dropdown-item" href="{{route('user.gallery')}}"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Photos', 'ne')  }} @else Photos @endif</a></li>
                            <li><a class="dropdown-item" href="{{route('user.videos')}}"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Videos', 'ne')  }} @else Videos @endif</a></li>
                        </ul>
                    </li>
                    <li class="nav-item dropdown secondDropDown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Results', 'ne')  }} @else Results @endif
                        </a>
                        <ul class="dropdown-menu dropdown-menu-show-2" aria-labelledby="navbarDropdown">
                            @foreach($course_name as $course)
                            <li><a class="dropdown-item" href="{{url('result',$course->id.'/'.$course->course_name_slug)}}"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($course->course_name, 'ne')  }} @else {{$course->course_name}} @endif</a></li>
                            @endforeach
                        </ul>
                    </li>
                    <li class="nav-item dropdown secondDropDown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Admission', 'ne')  }} @else Admission @endif
                        </a>
                        <ul class="dropdown-menu dropdown-menu-show-2" aria-labelledby="navbarDropdown">
                            @foreach($admissions as $admission)
                            <li><a class="dropdown-item" href="{{url('admission-details',$admission->id.'/'.$admission->title_slug)}}"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($admission->title, 'ne')  }} @else {{$admission->title}} @endif</a></li>
                            @endforeach
                        </ul>
                    </li>

                </ul>
            </div>
        </div>
    </nav>