@extends('admin.admin_master')
@section('admin.admin_content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Theme Update</h4>

    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">Theme Update</h5>

                    </div>

                </div>
                <!-- Account -->
                <hr class="my-0" />
                <div class="card-body">
                    <form id="formAccountSettings" method="POST" action="{{ route('admin.theme_update_store') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="row">
                            <h5 class="fw-bold py-3 mb-3">Theme Information</h5>
                            <div class="mb-3 col-md-12">
                                <label for="slider_heading" class="form-label">Address <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" id="address" placeholder="Tulsipur-6, Dang" name="address" value="{{ $theme_update->address }}" />
                                @error('address')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-12">
                                <label for="phone" class="form-label">Phone <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="phone" placeholder="+977 9809784742" value="{{ $theme_update->phone }}" id="phone" />
                                @error('phone')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-12">
                                <label for="telephone" class="form-label">Telephone <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" id="telephone" placeholder="086-401020" name="telephone" value="{{ $theme_update->telephone }}" />
                                @error('telephone')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-12">
                                <label for="email" class="form-label">E-mail <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="email" placeholder="example@gmail.com" value="{{ $theme_update->email }}" id="email" />
                                @error('email')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>

                        </div>


                        <h5 class="fw-bold py-3 mb-3">Theme Logo </h5>
                        <div class="row">
                        <div class="mb-3 col-md-6">
                            <label for="logo" class="form-label">English Logo <span class="text-danger">*</span></label>
                            <input type="file" class="form-control" id="logo" name="logo" onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                            @error('logo')
                            <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="mb-3 col-md-6">
                            <img src="{{ asset($theme_update->logo) }}" alt="" height="50px" id="adminProImg">
                        </div>
                        <div class="mb-3 col-md-6">
                            <label for="logo" class="form-label">Nepali Logo <span class="text-danger">*</span></label>
                            <input type="file" class="form-control" id="logo_np" name="logo_np" onchange="mainProImgUrl_1(this)" accept="image/png, image/jpeg" />
                            @error('logo_np')
                            <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="mb-3 col-md-6">
                            <img src="{{ asset($theme_update->logo_np) }}" alt="" height="50px" id="adminProImg_1">
                        </div>
                        <div class="mb-3 col-md-6">
                            <label for="logo" class="form-label">Page Background Image <span class="text-danger">*</span></label>
                            <input type="file" class="form-control" id="image" name="image" onchange="mainProImgUrl_2(this)" accept="image/png, image/jpeg" />
                            @error('image')
                            <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="mb-3 col-md-6">
                            <img src="{{ asset($theme_update->image) }}" alt="" height="50px" id="adminProImg_2">
                        </div>
                        </div>

                        <div class="mt-2 float-end">
                            <button type="submit" class="btn btn-primary me-2">Update Theme</button>
                            <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                        </div>
                </div>

                </form>
            </div>
            <!-- /Account -->
        </div>
    </div>
</div>
</div>
<!-- / Content -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    function mainProImgUrl(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#adminProImg').attr('src', e.target.result).width(80).height(80);
            };
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
<script>
    function mainProImgUrl_1(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#adminProImg_1').attr('src', e.target.result).width(80).height(80);
            };
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
<script>
    function mainProImgUrl_2(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#adminProImg_2').attr('src', e.target.result).width(80).height(80);
            };
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endsection