@extends('admin.admin_master')
@section('admin.admin_content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Edit Slider</h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <div class="row">
                        <div class="col-6 col">
                            <h5 class="card-header">Edit Slider</h5>
                        </div>
                        <div class="col-6 col card-header">
                            <a href="{{ route('admin.slider_view') }}"
                                class="float-end btn btn-primary text-nowrap add-new-role">View All Slider</a>
                        </div>
                    </div>
                    <!-- Account -->
                    <hr class="my-0" />
                    <div class="card-body">
                        <form id="formAccountSettings" method="POST"
                            action="{{ route('admin.slider_update', $sliderEdit->id) }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <h5 class="fw-bold py-3 mb-3">Slider Information</h5>
                                <div class="mb-3 col-md-12">
                                    <label for="slider_heading" class="form-label">Slider Heading <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control title_count" type="text" id="slider_heading"
                                        placeholder="Songs From the Mountains" name="slider_heading"
                                        value="{{ $sliderEdit->slider_heading }}" />
                                    @error('slider_heading')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                    <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>

                                </div>
                                <div class="mb-3 col-md-12">
                                    <label for="slider_sub_heading" class="form-label">Slider Sub Heading <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" type="text" name="slider_sub_heading"
                                        placeholder="A sountries old Festivals the mountain celebrating music in Himal"
                                        id="slider_sub_heading" value="{{ $sliderEdit->slider_sub_heading }}" />
                                    @error('slider_sub_heading')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>

                            </div>


                            <h5 class="fw-bold py-3 mb-3">Slider Image </h5>
                            <div class="mb-3 col-md-6">
                                <label for="image" class="form-label">Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" id="image" name="image"
                                    onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                                @error('image')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-6">
                                <img src="{{ asset($sliderEdit->image) }}" height="250px" alt="" id="adminProImg">
                            </div>
                            <div class="mt-2 float-end">
                                <button type="submit" class="btn btn-primary me-2">Update Slider</button>
                                <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                            </div>
                    </div>

                    </form>
                </div>
                <!-- /Account -->
            </div>
        </div>
    </div>
    </div>
    <!-- / Content -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
        function mainProImgUrl(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#adminProImg').attr('src', e.target.result).width(80).height(80);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endsection
