@extends('admin.admin_master')
@section('admin.admin_content')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css"
        integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- ✅ load jQuery ✅ -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"
        integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>


    <!-- ✅ load DataTables ✅ -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js"
        integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- Content -->
    <section>

        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> View Courses</h4>

            @php
                $i = 1;
            @endphp
            <!-- Basic Bootstrap Table -->
            <div class="card">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">List Courses</h5>

                    </div>
                    <div class="col-6 col card-header">
                        <a href="{{ route('admin.reason_all_add') }}"
                            class="float-end btn btn-primary text-nowrap add-new-role text-white">Add New Course</a>
                    </div>
                </div>


                <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
                    <table class="table" id="exampleTable" width="100%">
                        <thead>
                            <tr class="text-nowrap">
                                <th>SN</th>
                                <th>Reason Name</th>
                                <th>Thumbnail Icon</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                        @foreach ($reason_pages as $key=>$reason_page)
                            <tr>
                                <td>{{ $key+1 }}</td>
                                <td>{{ $reason_page->reason_name }}</td>
                                <td><img src="{{ asset($reason_page->icon) }}" height="40px" alt=""></td>
                                <td><a href="{{ route('admin.reason_all_edit',$reason_page->id) }}"
                                    class="btn btn-primary text-white">Edit</a> <a
                                    href="{{ route('admin.reason_all_delete', $reason_page->id) }}" id="deleteData"
                                    class="btn btn-danger">Delete</a></td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Basic Bootstrap Table -->
        </div>
        <!-- / Content -->

    </section>
    <script>
        $(document).ready(function() {
            $.noConflict();
            $('#exampleTable').DataTable();
        });
    </script>
@endsection
