@extends('admin.admin_master')
@section('admin.admin_content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Create Course Page</h4>

        <div class="row">
            <div class="col-md-12">

                <div class="card mb-4">
                    <div class="row">
                        <div class="col-6 col">
                            <h5 class="card-header">Add Reason Page</h5>

                        </div>
                        <div class="col-6 col card-header">
                            <a href="{{ route('admin.reason_all_view') }}"
                                class="float-end btn btn-primary text-nowrap add-new-role">View All Reason</a>
                        </div>
                    </div>
                    <!-- Account -->
                    <hr class="my-0" />
                    <div class="card-body">
                        <form id="formAccountSettings" method="POST" action="{{ route('admin.reason_all_update',$reason_edit->id) }}" enctype="multipart/form-data"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <h5 class="fw-bold py-3 mb-3">Reason Information</h5>
                                <div class="mb-3 col-md-12">
                                    <label for="reason_name" class="form-label">Reason Name <span
                                            class="text-danger">*</span></label>
                                    <input name="reason_name" class="form-control title_count" value="{{ $reason_edit->reason_name }}" placeholder="Physics Labs" type="text">
                                    @error('reason_name')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                    <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>

                                </div>
                                <div class="mb-3 col-md-12">
                                    <label for="short_des" class="form-label">Reason Short Description <span
                                            class="text-danger">*</span></label>
                                            <textarea name="short_des" id="short_des" class="form-control" cols="5" rows="5">{{ $reason_edit->short_des }}</textarea>
                                    @error('short_des')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-12">
                                    <label for="des" class="form-label">Reason Long Description <span
                                            class="text-danger">*</span></label>
                                            <textarea name="des" id="des" class="form-control ckeditor" cols="5" rows="5">{{ $reason_edit->des }}</textarea>
                                   
                                    @error('des')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div> 
                            <h5 class="fw-bold py-3 mb-3">Thumbnail Icon </h5>
                            <div class="mb-3 col-md-6">
                                <label for="icon" class="form-label">Icon <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" id="icon" name="icon"
                                    onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                                @error('icon')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-6">
                                <img src="{{ asset($reason_edit->icon) }}" alt="" height="60px">
                            </div>
                            <div class="mt-2 float-end">
                                <button type="submit" class="btn btn-primary me-2">Update Page</button>
                                <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                            </div>
                    </div>

                    </form>
                </div>
                <!-- /Account -->
            </div>
        </div>
    </div>
    </div>
    <!-- / Content -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
        function mainProImgUrl(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#adminProImg').attr('src', e.target.result).width(80).height(80);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
     <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
     <script type="text/javascript">
         $(document).ready(function() {
             $('.ckeditor').ckeditor();
         });
     </script>
 
@endsection
