@extends('admin.admin_master')
@section('admin.admin_content')
<style>
    td,
    th {
        font-size: 12px;
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css" integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<!-- ✅ load jQuery ✅ -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js" integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>


<!-- ✅ load DataTables ✅ -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js" integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!-- Content -->
<!-- Content -->
<section>

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> View Download Files</h4>

        @php
        $i = 1;
        @endphp
        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="row">
                <div class="col-6 col">
                    <h5 class="card-header">List Files</h5>

                </div>
                <div class="col-6 col card-header">
                    <a href="{{ route('admin.download_all_add') }}" class="float-end btn btn-primary text-nowrap add-new-role text-white">Add New File</a>
                </div>
            </div>


            <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
                <table class="table" id="exampleTable" width="100%">
                    <thead>
                        <tr class="text-nowrap">
                            <th>SN</th>
                            <th>Published Date</th>
                            <th>Notice Title</th>
                            <th>Files</th>
                            <th>Published By</th>
                     
                            <th>Status</th>
                            <th>Pending</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        @foreach ($download_date as $key=> $download)
                        <tr>
                            <td>{{ $i++ }}</td>
                            <td width="20%">@php
                                $year = $download->created_at->format('Y');
                                $month = $download->created_at->format('m');
                                $day = $download->created_at->format('d');
                                $date = Bsdate::eng_to_nep($year, $month, $day);
                                echo $date['date'] . ' ' . $date['nmonth'] . ' ' . $date['year'] . ',' . $date['day'];
                                @endphp</td>
                            <td width="20%">{{ $download->title }}</td>
                            <td>@php
                                $files = \App\Models\DownloadFile::where('download_id', $download->id)->get();
                                @endphp
                                @foreach ($files as $file)
                                <i class="bi bi-file-earmark-pdf-fill"></i>
                                @endforeach
                            </td>
                            <td>{{ $download->user->name }}</td>
                            @if ($download->status == 1)
                            <td><span class="badge bg-success text-capitalize rounded-pill">Active</span></td>
                            @else
                            <td><span class="badge bg-danger text-capitalize rounded-pill">Inactive</span></td>
                            @endif
                            @if ($download->public == 1)
                            <td><span class="badge bg-success text-capitalize rounded-pill">Posted</span></td>
                            @elseif($download->public == 2)
                            <td><span class="badge bg-danger text-capitalize rounded-pill">Rejected</span></td>
                            @else
                            <td><span class="badge bg-danger text-capitalize rounded-pill">Pending...</span></td>
                            @endif
                            <td>
                                @php
                                $user_auth = \Illuminate\Support\Facades\Auth::user();
                                @endphp
                                @if($user_auth->admin_type == "Author User")
                                <a href="{{ route('admin.download_all_edit', $download->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil"></i></a>
                                <a href="{{ route('admin.download_all_delete', $download->id) }}" id="deleteData" class="btn btn-primary btn-sm"><i class="bi bi-trash"></i></a>

                               
                                @if ($download->status == 1)
                                <a href="{{ route('admin.download_all_active', $download->id) }}" class="btn btn-sm btn-danger"><i class="bi bi-arrow-down"></i></a>
                                @else
                                <a href="{{ route('admin.download_all_inactive', $download->id) }}" class="btn btn-sm btn-success"><i class="bi bi-arrow-up"></i></a>
                                @endif
                                <a href="{{ route('admin.download_reject', $download->id) }}" class="btn btn-sm btn-danger" title="Reject"><i class="bi bi-x-lg"></i></a>
                                <a href="{{ route('admin.download_accept', $download->id) }}" class="btn btn-sm btn-primary" title="Posted"><i class="bi bi-check-lg"></i></a>


                                @else
                                <span class="text-danger">Action connot access</span>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>
        </div>
        <!--/ Basic Bootstrap Table -->
    </div>
    <!-- / Content -->

</section>
<script>
    $(document).ready(function() {
        $.noConflict();
        $('#exampleTable').DataTable();
    });
</script>
<script>
    $('#tablebqup').DataTable().ajax.reload();
</script>
@endsection