@extends('admin.admin_master')
@section('admin.admin_content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Edit News & Notice</h4>

    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">Edit News & Notice</h5>

                    </div>
                    <div class="col-6 col card-header">
                        <a href="{{ route('admin.news_notice_view') }}" class="float-end btn btn-primary text-nowrap add-new-role">View All News & Notice</a>
                    </div>
                </div>
                <!-- Account -->
                <hr class="my-0" />
                <div class="card-body">
                    <form id="formAccountSettings" method="POST" action="{{ route('admin.news_notice_update',$news_notice_edit->id) }}" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <h5 class="fw-bold py-3 mb-3">News & Notice Information</h5>
                            <div class="mb-3 col-md-12">
                                <label for="notice_title" class="form-label">News & Notice Title <span class="text-danger">*</span></label>
                                <input type="text" name="notice_title" id="notice_title" value="{{$news_notice_edit->notice_title}}" class="form-control title_count" placeholder="Graduation/Farewell Notice - 2017 Batch
">
                                @error('notice_title')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                                <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>
                            </div>
                            <div class="mb-3 col-md-12">
                                <label for="notice_title" class="form-label">News & Notice Type <span class="text-danger">*</span></label>
                                <select name="notice_type" id="notice_type" class="form-control">
                                    <option value="" disabled="" selected="">Select News and Notice Type</option>
                                    <option value="College" {{$news_notice_edit->notice_type == "College"?"selected":""}}>College</option>
                                    <option value="Exam" {{$news_notice_edit->notice_type == "Exam"?"selected":""}}>Exam</option>
                                    <option value="School" {{$news_notice_edit->notice_type == "School"?"selected":""}}>School</option>
                                    <option value="All" {{$news_notice_edit->notice_type == "All"?"selected":""}}>All</option>
                                </select>

                                @error('notice_title')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="container">
                                <div class="mt-2 float-end">
                                    <button type="submit" class="btn btn-primary me-2">Update Notice & News</button>
                                    <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
                <!-- /Account -->
            </div>
        </div>
    </div>
    @php
$multiple_notice = \App\Models\NewsNoticeImage::where('notice_id', $news_notice_edit->id)->get();
@endphp
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="row">
                <div class="col-6 col">
                    <h5 class="card-header">Multi Notice Edit</h5>
                </div>
            </div>
            <div class="box-body">
                <form action="{{route('admin.news_notice_image_update')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row row-sm">
                        @foreach ($multiple_notice as $items)
                        <div class="col-md-3">
                            <div class="card">

                                <div class="card-body">
                                    <img class="card-img-top" src=" {{ asset($items->image) }}" alt="Card image cap" height="130px" width="280px">
                                    <div class="card-title">
                                        <a href="{{route('admin.news_notice_image_delete',$items->id)}}" class="btn btn-danger mt-2" id="deleteData"><i class="bi bi-trash"></i></a>
                                    </div>
                                    <div class="card-text">
                                        <div class="form-group">
                                            <label class="form-control-label">Change Notice <span class="text-danger">*</span></label>
                                            <input type="file" name="image[{{ $items->id }}]" id="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach

                    </div>
                    <div class="container">
                        <div class="col-12 mt-3 text-end">
                            <button type="submit" class="btn btn-primary">Update Notice & News</button>
                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>

</div>
</div>


</div>
<!-- / Content -->
<!-- / Content -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>


<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('.ckeditor').ckeditor();
    });
</script>

@endsection