@extends('admin.admin_master')
@section('admin.admin_content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Create News & Notice</h4>

    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">Add News & Notice</h5>

                    </div>
                    <div class="col-6 col card-header">
                        <a href="{{ route('admin.news_notice_view') }}" class="float-end btn btn-primary text-nowrap add-new-role">View All News & Notice</a>
                    </div>
                </div>
                <!-- Account -->
                <hr class="my-0" />
                <div class="card-body">
                    <form id="formAccountSettings" method="POST" action="{{ route('admin.news_notice_store') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <h5 class="fw-bold py-3 mb-3">News & Notice Information</h5>
                            <div class="mb-3 col-md-12">
                                <label for="notice_title" class="form-label">News & Notice Title <span class="text-danger">*</span></label>
                                <input type="text" name="notice_title" id="notice_title" class="form-control title_count" placeholder="Graduation/Farewell Notice - 2017 Batch
">
                                @error('notice_title')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                                <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>
                            </div>
                            <div class="mb-3 col-md-12">
                                <label for="notice_title" class="form-label">News & Notice Type <span class="text-danger">*</span></label>
                                <select name="notice_type" id="notice_type" class="form-control">
                                    <option value="" disabled="" selected="">Select News and Notice Type</option>
                                    <option value="College">College</option>
                                    <option value="Exam">Exam</option>
                                    <option value="School">School</option>
                                    <option value="All">All</option>
                                </select>

                                @error('notice_title')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <h5 class="fw-bold py-3 mb-3">Notice Image </h5>
                            <div class="mb-3 col-md-6">
                                <label for="image" class="form-label">Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" name="image[]" multiple="" id="multiImg" onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                                @error('image')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-12">
                                <div class="row" id="preview_img">

                                </div>
                            </div>
                            <div class="container">
                            <div class="mt-2 float-end">
                                <button type="submit" class="btn btn-primary me-2">Add Notice & News</button>
                                <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                            </div>
                            </div>
                        </div>

                    </form>
                </div>
                <!-- /Account -->
            </div>
        </div>
    </div>
</div>
<!-- / Content -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<script>
    $(document).ready(function() {
        $('#multiImg').on('change', function() { //on file input change
            if (window.File && window.FileReader && window.FileList && window.Blob) //check File API supported browser
            {
                var data = $(this)[0].files; //this file data

                $.each(data, function(index, file) { //loop though each file
                    if (/(\.|\/)(gif|jpe?g|png)$/i.test(file.type)) { //check supported file type
                        var fRead = new FileReader(); //new filereader
                        fRead.onload = (function(file) { //trigger function on successful read
                            return function(e) {
                                var img = $('<img/>').addClass('thumb').attr('src', e.target.result).width(80)
                                    .height(80); //create image element 
                                $('#preview_img').append(img); //append image to output element
                            };
                        })(file);
                        fRead.readAsDataURL(file); //URL representing the file's data.
                    }
                });

            } else {
                alert("Your browser doesn't support File API!"); //if File API is absent
            }
        });
    });
</script>
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('.ckeditor').ckeditor();
    });
</script>

@endsection