@extends('admin.admin_master')
@section('admin.admin_content')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css"
        integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- ✅ load jQuery ✅ -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"
        integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>


    <!-- ✅ load DataTables ✅ -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js"
        integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- Content -->
    <section>

        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> View Entrance</h4>

            @php
                $i = 1;
            @endphp
            <!-- Basic Bootstrap Table -->
            <div class="card">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">List Entrance</h5>

                    </div>
                    <div class="col-6 col card-header">
                        <a href="{{route('admin.entrance_add')}}"
                            class="float-end btn btn-primary text-nowrap add-new-role text-white">Add New Entrance</a>
                    </div>
                </div>


                <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
                    <table class="table" id="exampleTable" width="100%">
                        <thead>
                            <tr class="text-nowrap">
                                <th>SN</th>
                                <th>Entrance</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            @foreach ($entrance as $admission)
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{ $admission->title }}</td>
                                    <td>
                                    @php
        $user_auth = \Illuminate\Support\Facades\Auth::user();
        @endphp
        @if($user_auth->admin_type == "Author User")
                                        <a href="{{route('admin.entrance_edit',$admission->id)}}"
                                            class="btn btn-primary text-white">Edit</a> <a
                                            href="{{ route('admin.entrance_delete', $admission->id) }}" id="deleteData"
                                            class="btn btn-danger">Delete</a>
                                        @else
                                        <span>Action connot access</span>
                                        @endif
                                        </td>
                                </tr>
                             
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Basic Bootstrap Table -->
        </div>
        <!-- / Content -->

     


    </section>
    <script>
        $(document).ready(function() {
            $.noConflict();
            $('#exampleTable').DataTable();
        });
    </script>
    
@endsection
