@extends('admin.admin_master')
@section('admin.admin_content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Create Deparmtents Page</h4>

        <div class="row">
            <div class="col-md-12">

                <div class="card mb-4">
                    <div class="row">
                        <div class="col-6 col">
                            <h5 class="card-header">Add Departments Page</h5>

                        </div>
                        <div class="col-6 col card-header">
                            <a href="{{ route('admin.user__department_view') }}"
                                class="float-end btn btn-primary text-nowrap add-new-role">View All Department</a>
                        </div>
                    </div>
                    <!-- Account -->
                    <hr class="my-0" />
                    <div class="card-body">
                        <form id="formAccountSettings" method="POST" action="{{ route('admin.user__department_add_store') }}"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <h5 class="fw-bold py-3 mb-3">Department Information</h5>
                                <div class="mb-3 col-md-12">
                                    <label for="slider_heading" class="form-label">Departments Name <span
                                            class="text-danger">*</span></label>
                                    <select name="course_id" id="course_id" class="form-control">
                                        <option value="">Select Course</option>
                                        @foreach ($departments as $course_names)
                                            <option value="{{ $course_names->id }}">{{ $course_names->course_name }}</option>
                                        @endforeach
                                    </select>
                                    @error('course_id')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-12">
                                    <label for="des" class="form-label">Course Short Description <span
                                            class="text-danger">*</span></label>
                                            <textarea name="des" id="des" class="form-control ckeditor" cols="5" rows="5"></textarea>
                                    @error('des')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-12">
                                    <label for="dept_message" class="form-label">Departments Message <span
                                            class="text-danger">*</span></label>
                                            <textarea name="dept_message" id="dept_message" class="form-control ckeditor" cols="5" rows="5"></textarea>
                                   
                                    @error('dept_message')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div> 
                            <h5 class="fw-bold py-3 mb-3">User Image </h5>
                            <div class="mb-3 col-md-6">
                                <label for="image" class="form-label">Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" id="image" name="image"
                                    onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                                @error('image')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="mb-3 col-md-6">
                                <img src="" alt="" id="adminProImg">
                            </div>
                            <div class="mt-2 float-end">
                                <button type="submit" class="btn btn-primary me-2">Add Page</button>
                                <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                            </div>
                    </div>

                    </form>
                </div>
                <!-- /Account -->
            </div>
        </div>
    </div>
    </div>
    <!-- / Content -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
        function mainProImgUrl(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#adminProImg').attr('src', e.target.result).width(80).height(80);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
     <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
     <script type="text/javascript">
         $(document).ready(function() {
             $('.ckeditor').ckeditor();
         });
     </script>
 
@endsection
