<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DepartmentDownload;
use App\Models\Download;
use App\Models\Event;
use App\Models\Gallery;
use App\Models\Message;
use App\Models\NewsNotice;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use RealRashid\SweetAlert\Facades\Alert;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Brian2694\Toastr\Facades\Toastr;


class AdminUserController extends Controller
{
    //Admin User Profile
    public function AdminUserProfile()
    {
        $admin_user = Auth::user();
        return view('admin.profile.user_profile', compact('admin_user'));
    }

    //Admin Profile Image Store
    public function AdminProfileImage(Request $request)
    {
        $request->validate([
            'profile_photo_path' => 'mimes:jpg,png,jpeg|max:800|required'
        ]);
        $admin_profile_img = User::find(Auth::id());
        if ($request->file('profile_photo_path')) {
            $file = $request->file('profile_photo_path');
            @unlink($admin_profile_img->profile_photo_path);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/admin_images/' . $filename);
            $uploadPath = './uploads/admin_images/' . $filename;
        }
        $admin_profile_img->profile_photo_path = $uploadPath;
        $admin_profile_img->save();
        Toastr::success('User Profile Image Updated Successfully');
        return redirect()->back();
    }


    //Admin Profile Info Store
    public function AdminProfileInfoStore(Request $request)
    {
        $request->validate([
            'name' => 'max:255|required',
            'website' => "max:255|nullable",
            'phone' => "min:10|numeric|nullable",
            'facebook_link' => "max:255|nullable",
            'address' => "max:255|nullable",
            'dob' => "max:255|nullable",
        ]);
        $admin_profile_store = User::find(Auth::id());
        $admin_profile_store->name = $request->name;
        $admin_profile_store->phone = $request->phone;
        $admin_profile_store->dob = $request->dob;
        $admin_profile_store->address = $request->address;
        $admin_profile_store->website = $request->website;
        $admin_profile_store->facebook_link = $request->facebook_link;
        $admin_profile_store->about = $request->about;
        $admin_profile_store->save();
        Toastr::success('User Profile Updated Successfully');
        return redirect()->back();
    }

    //Admin Password change
    public function AdminUserPasswordview()
    {
        return view('admin.profile.password');
    }


    //Check Current Password 
    public function checkUserPassword(Request $request)
    {
        $current_pass = $request->current_password;
        $admin_id = User::find(Auth::id());
        if (Hash::check($current_pass, $admin_id->password)) {
            return "true";
            die;
        } else {
            return "false";
            die;
        }
    }


    //Save Password Password 
    public function ChangePasswordUpdate(Request $request)
    {
        $request->validate([
            'current_password' => 'required|max:23|min:8',
            'password' => 'required|max:23|min:8',
            'confirm_password' => 'required|max:23|min:8|same:password',
        ]);
        $new_pass = $request->password;
        $current_pass = $request->current_password;
        $id = Auth::id();
        $user = User::find($id);
        $data = $request->all();
        if (Hash::check($current_pass, $user->password)) {
            $user->password = Hash::make($new_pass);
            $user->save();
            Toastr::success('User Password Has Been Updated Successfully');
            toast('User Password Has Been Updated Successfully', 'bottom-end');
            return redirect()->route('login');
        } else {
            Toastr::success('User Password does not match with our database');
            return redirect()->back();
        }
    }

    //User Admin Logout
    public function AdminLogout()
    {
        Auth::logout();
        return redirect()->route('login');
    }

    //Admin User View
    public function AdminUserAllView()
    {
        Session::put('admin_page', 'admin_user_view');
        $users = User::where('id','!=',1)->latest()->get();
        return view('admin.user.user_view', compact('users'));
    }
    //Admin User Add
    public function AdminUserAddView()
    {
        Session::put('admin_page', 'admin_user_view');
        return view('admin.user.user_add');
    }

    //Admin Add Store
    public function AdminUserAddInfoStore(Request $request)
    {
        if ($request->admin_type == "Normal User") {

            $request->validate([
                'name' => 'required|max:255|min:4',
                'email' => 'required|max:255|min:4|email|unique:users,email',
                'website' => "max:255|nullable",
                'phone' => "min:10|numeric|nullable",
                'facebook_link' => "max:255|nullable",
                'address' => "max:255|nullable",
                'admin_type' => "required",
                'profile_photo_path' => 'nullable|mimes:jpg,png,jpeg|max:800',
            ]);
            $user_info = new User();
            $user_info->name = $request->name;
            $user_info->email = $request->email;
            $user_info->website = $request->website;
            $user_info->phone = $request->phone;
            $user_info->facebook_link = $request->facebook_link;
            $user_info->address = $request->address;
            $user_info->user_post = $request->user_post;
            $user_info->about = $request->about;
            $user_info->admin_type = $request->admin_type;
            $user_info->password = Hash::make('sushilkc98687027');
            if ($request->file('profile_photo_path')) {
                $file = $request->file('profile_photo_path');
                @unlink($user_info->profile_photo_path);
                $filename = date('YmsHi') . $file->getClientOriginalName();
                Image::make($file)->save('./uploads/admin_images/' . $filename);
                $uploadPath = './uploads/admin_images/' . $filename;
                $user_info->profile_photo_path = $uploadPath;
            }
            $user_info->save();
            Toastr::success('User Added Successfully');
            return redirect()->back();
        } else {
            $request->validate([
                'name' => 'required|max:255|min:4',
                'email' => 'required|max:255|min:4|email|unique:users,email',
                'password' => 'required|min:8|max:255',
                'confirm_password' => 'required|max:23|min:8|same:password',
                'website' => "max:255|nullable",
                'phone' => "min:10|numeric|nullable",
                'facebook_link' => "max:255|nullable",
                'address' => "max:255|nullable",
                'admin_type' => "required",
                'profile_photo_path' => 'nullable|mimes:jpg,png,jpeg|max:800',
            ]);
            $user_info = new User();
            $user_info->name = $request->name;
            $user_info->email = $request->email;
            $user_info->user_post = $request->user_post;
            $user_info->website = $request->website;
            $user_info->phone = $request->phone;
            $user_info->facebook_link = $request->facebook_link;
            $user_info->address = $request->address;
            $user_info->about = $request->about;
            $user_info->admin_type = $request->admin_type;
            $user_info->password = Hash::make($request->password);
            if ($request->file('profile_photo_path')) {
                $file = $request->file('profile_photo_path');
                @unlink($user_info->profile_photo_path);
                $filename = date('YmsHi') . $file->getClientOriginalName();
                Image::make($file)->save('./uploads/admin_images/' . $filename);
                $uploadPath = './uploads/admin_images/' . $filename;
                $user_info->profile_photo_path = $uploadPath;
            }
            $user_info->save();
            Toastr::success('User Added Successfully');
            return redirect()->back();
        }
    }
    //User Edit
    public function AdminUserAllEdit($id)
    {
        Session::put('admin_page', 'admin_user_view');
        $user_edit = User::find($id);
        return view('admin.user.user_edit', compact('user_edit'));
    }

    //User Information Update
    public function AdminUserAddInfoUpdate(Request $request,$id)
    {
        $request->validate([
            'name' => 'required|max:255|min:4',
            'website' => "max:255|nullable",
            'phone' => "min:10|numeric|nullable",
            'facebook_link' => "max:255|nullable",
            'address' => "max:255|nullable",
            'admin_type' => "required",
            'profile_photo_path' => 'nullable|mimes:jpg,png,jpeg|max:800',
        ]);
        $user_info = User::find($id);
        $user_info->name = $request->name;
        $user_info->website = $request->website;
        $user_info->phone = $request->phone;
        $user_info->facebook_link = $request->facebook_link;
        $user_info->address = $request->address;
        $user_info->about = $request->about;
        $user_info->user_post = $request->user_post;
        $user_info->admin_type = $request->admin_type;
        if ($request->file('profile_photo_path')) {
            $file = $request->file('profile_photo_path');
            @unlink($user_info->profile_photo_path);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/admin_images/' . $filename);
            $uploadPath = './uploads/admin_images/' . $filename;
            $user_info->profile_photo_path = $uploadPath;
        }
        $user_info->save();
        Toastr::success('User Updated Successfully');
        return redirect()->back();   
    }


    //Admin User Delete 
    public function AdminUserAllDelete($id)
    {
        if (DepartmentDownload::where('user_id', $id)->count() > 0 or Download::where('user_id', $id)->count() > 0 or Event::where('user_id', $id)->count() > 0 or Gallery::where('user_id', $id)->count() > 0 or NewsNotice::where('user_id', $id)->count() > 0 or Message::where('user_id', $id)->count() > 0) {
            Toastr::warning('User has not been delete');
            return redirect()->back();
        } else {
        $user_delete = User::find($id);
        $user_delete->delete();
        Toastr::success('User Deleted Successfully');
        return redirect()->back();
        }
    }
}
