<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\QuickAccess;
use App\Models\Resource;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;

class AdminResourcesController extends Controller
{
    //Footer Resource View
    public function ResourceView()
    {
        Session::put('admin_page', 'admin_footer_view');
        $resource = Resource::latest()->get();
        return view('admin.footer.footer_resourse', compact('resource'));
    }


    //Footer Resource Store
    public function ResourceStore(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255',
            'link' => 'required|max:255',
        ]);
        $quickaccess = new Resource();
        $quickaccess->name = $request->name;
        $quickaccess->link = $request->link;
        $quickaccess->save();
        Toastr::success('Resource Added Successfully');
        return redirect()->back();
    }

    //Footer Resource Update
    public function ResourceUpdate(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|max:255',
            'link' => 'required|max:255',
        ]);
        $quickaccess = Resource::find($id);
        $quickaccess->name = $request->name;
        $quickaccess->link = $request->link;
      
        $quickaccess->save();
        Toastr::success('Resource Updated Successfully');
        return redirect()->back();
    }

    //Footer Resource Delete
    public function ResourceDelete($id)
    {
        $quickaccess_delete = Resource::find($id);
        @unlink($quickaccess_delete->logo);
        $quickaccess_delete->delete();
        Toastr::success('Resource Deleted Successfully');
        return redirect()->back();
    }
}
