<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CoursePart;
use App\Models\Course;
use Illuminate\Support\Facades\Session;
use App\Models\CourseSubject;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Str;
use Brian2694\Toastr\Facades\Toastr;

class AdminCourseSubjectController extends Controller
{
    //
    public function AdminCoursePartSubject($id)
    {
        $course_details = CoursePart::latest()->get();
        $course_view = Course::latest()->get();
        $course_subject_view = CourseSubject::where('course_part_id',$id)->get();
        return view('admin.course.course_part_subject', compact('course_subject_view','course_details','course_view'));
    }


    public function AdminCoursePartSubjectAJAX(Request $request)
    {
        $course_id = $request->course_id;
        $allData = CoursePart::where('course_id', $course_id)->get();
        return response()->json($allData);
    }

    //Course Add
    public function AdminCoursePartStoreSubject(Request $request)
    {
        $request->validate([
            'course_id' => 'max:255|required',
            'course_part_id' => 'max:255|required',
            'subject_code' => 'max:255|required',
            'subject_name' => 'max:255|required',
            'subject_hours' => 'max:255|required',
        ]);
        $course_part_store = new CourseSubject();
        $course_part_store->course_id = $request->course_id;
        $course_part_store->course_part_id = $request->course_part_id;
        $course_part_store->subject_code = $request->subject_code;
        $course_part_store->subject_name = $request->subject_name;
        $course_part_store->subject_name_slug = Str::slug($request->subject_name);
        $course_part_store->subject_hours = $request->subject_hours;
        $course_part_store->save();
        Toastr::success('Course Subject Created Successfully');
        return redirect()->back();
    }

    //Course Edit
    public function AdminCoursePartUpdateSubject(Request $request, $id)
    {
        $request->validate([
            'course_id' => 'max:255|required',
            'course_part_id' => 'max:255|required',
            'subject_code' => 'max:255|required',
            'subject_name' => 'max:255|required',
            'subject_hours' => 'max:255|required',
        ]);
        $course_part_update =  CourseSubject::find($id);
        $course_part_update->course_id = $request->course_id;
        $course_part_update->course_part_id = $request->course_part_id;
        $course_part_update->subject_code = $request->subject_code;
        $course_part_update->subject_name = $request->subject_name;
        $course_part_update->subject_name_slug = Str::slug($request->subject_name);
        $course_part_update->subject_hours = $request->subject_hours;
        $course_part_update->save();
        Toastr::success('Course Subject Updated Successfully');
        return redirect()->back();
    }


    public function AdminCoursePartEdit($id)
    {
        $course_details = CoursePart::where('course_id',$id)->get();
        $course_view = Course::latest()->get();
        return view('admin.course.course_part_edit', compact('course_details','course_view'));
    }
    //Course Add
    public function AdminCoursePartSubjectDelete($id)
    {
        $course_delete = CourseSubject::find($id);
        $course_delete->delete();
        Toastr::success('Course Subject Deleted Successfully');
        return redirect()->back();
    }
}
