<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Course;
use Illuminate\Http\Request;
use PHPUnit\Framework\Constraint\Count;
use App\Models\CoursePage;
use App\Models\CoursePart;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use Brian2694\Toastr\Facades\Toastr;
use Intervention\Image\Facades\Image;

class AdminCoursePageController extends Controller
{
    //Course Page View
    public function AdminCoursePageView()
    {
        Session::put('admin_page', 'admin_course_page_view');
        $course_pages = CoursePage::latest()->get();
        return view('admin.course_page.course_page_view', compact('course_pages'));
    }
    //Course Page Add 
    public function AdminCoursePageAdd()
    {
        Session::put('admin_page', 'admin_course_page_view');
        $course_name = Course::orderBy('course_name', 'ASC')->get();
        return view('admin.course_page.course_page_add', compact('course_name'));
    }

    //Course Page Edit 
    public function AdminCoursePageEdit($id)
    {
        Session::put('admin_page', 'admin_course_page_view');
        $course_page_content = CoursePage::find($id);
        $course_name = Course::orderBy('course_name', 'ASC')->get();
        return view('admin.course_page.course_page_edit', compact('course_page_content','course_name'));
    }

    //Course Page Add 
    public function AdminCoursePageStore(Request $request)
    {
        $request->validate([
            'course_id' => 'max:255|required',
            'short_description' => 'max:500|required',
            'course_description' => 'required',
            'image' => 'required',
        ]);
        $course_page_add = new CoursePage();
        $course_page_add->course_id = $request->course_id;
        $course_page_add->short_description = $request->short_description;
        $course_page_add->short_description_slug = Str::slug($request->short_description);
        $course_page_add->course_description = $request->course_description;
        if ($request->file('image')) {
            $file = $request->file('image');
            @unlink($course_page_add->image);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/course_images/' . $filename);
            $uploadPath = './uploads/course_images/' . $filename;
           
        }
        $course_page_add->image = $uploadPath;
        $course_page_add->save();
        Toastr::success('Course Page Created Successfully');
        return redirect()->back();
    }

    //Course Page update 
    public function AdminCoursePageUpdate(Request $request,$id)
    {
        $request->validate([
            'course_id' => 'max:255|required',
            'short_description' => 'max:500|required',
            'course_description' => 'required',
            'image' => 'nullable',
        ]);
        $course_page_update = CoursePage::find($id);
        $course_page_update->course_id = $request->course_id;
        $course_page_update->short_description = $request->short_description;
        $course_page_update->short_description_slug = Str::slug($request->short_description);
        $course_page_update->course_description = $request->course_description;
        if ($request->file('image')) {
            $file = $request->file('image');
            @unlink($course_page_update->image);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/course_images/' . $filename);
            $uploadPath = './uploads/course_images/' . $filename;
            $course_page_update->image = $uploadPath;
        }
     
        $course_page_update->save();
        Toastr::success('Course Page Updated Successfully');
        return redirect()->back();
    }



    public function AdminCoursePageDelete($id){
        $course_page_delete = CoursePage::find($id);
        @unlink($course_page_delete->image);
        Toastr::success('Course Page Deleted Successfully');
        $course_page_delete->delete();
        return redirect()->back();
    }
}
